set more off 
pause off
set logtype text
set mem 500M

*************** DESCRIPTION *************************************
* Imports investor classification as defined by Bushee (2001) and 
* downloaded from http://acct.wharton.upenn.edu/faculty/bushee/IIclass.html
* 
* Merges investor classification with Thomson Reuters (TR) 13f 
* and stores owner x CUSIP intermediate file
*
*	Inputs: bushee_data_2015 --> Bushee's investor classification
*			S34_datapull --> Raw data pull from TR S34
*	
*	Outputs: 2.intermediate\bushee_detailed --> Investor x CUSIP 
*			 dataset
*
* Note:
*	- rdate is the date for which the holdings are valid; BUT
*	- fdate is the date for which share price and shares outstanding are given in TR
* We therefore compute total share ownership by rdate, and pull share 
* price and shares outstanding from CRSP using ncusip8 for the given rdate
*****************************************************************

use 0.raw_inputs\bushee_data_2015, clear
g negmrgno_v = - mgrno_v
sort negmrgno_v 
bys mgrno year: keep if _n==1
save temp, replace

* Load Thomson Reuter investor ownership data, and merge with Bushee classification
use 0.raw_inputs\s34_datapull, clear
keep if month(rdate) == 12
g year = year(rdate) 
drop shrout*
drop rdate

drop if cusip == "" 
duplicates drop mgrno cusip year, force
merge m:1 mgrno year using temp, keepusing(invpermclass)
drop _merge

rename invpermclass invclass

replace invclass = "NA" if invclass == "" | invclass =="."

g mgrno_mapped = mgrno

g repl = 0
replace repl = 1 if inlist(mgrname, "BLACKROCK ADVISORS, LLC", "BLACKROCK ASSET MGMT IRELAND L", ///
"BLACKROCK FINL MGMT (SSR&M)", "BLACKROCK FINL MGMT, INC. (ML)", "BLACKROCK INC", "BLACKROCK, INC.", ///
"BLACKROCK INVESTMENT MGMT, LLC", "BLACKROCK INVT MGMT (UK) LTD.", "BLACKROCK JAPAN CO., LTD.")
replace mgrno_mapped = 11386 if repl == 1

replace repl = 0
replace repl = 1 if inlist(mgrname, "CAPITAL RESEARCH & MGMT", "CAPITAL RESEARCH & MGMT CO", ///
"CAPITAL RESEARCH & MGMT CO.", "CAPITAL RESEARCH GBL INVESTORS")
replace mgrno_mapped = 12740 if repl == 1

replace repl = 0
replace repl = 1 if inlist(mgrname, "DIMENSIONAL FD ADVISORS, INC.", "DIMENSIONAL FD ADVISORS, L.P.", ///
"DIMENSIONAL FUND ADVISORS, LP", "DIMENSIONAL FUND ADVS.")
replace mgrno_mapped = 11386 if repl == 1

replace repl = 0
replace repl = 1 if inlist(mgrname, "FIDELITY INTERNATIONAL", "FIDELITY INTERNATL LTD", ///
"FIDELITY INTL LTD", "FIDELITY INTL. LTD.", "FIDELITY MANAGEMENT & RESEARCH", ///
"FIDELITY MGMT & RES CORP", "FIDELITY MGMT & RESEARCH (US)", "FIDELITY MGMT & RESEARCH CO")
replace mgrno_mapped = 27700 if repl == 1

replace repl = 0
replace repl = 1 if inlist(mgrname, "STATE STR BK & TRUST CO BOSTON", "STATE STR CORP", ///
"STATE STR CORPORATION", "STATE STR GBL ADVR IRELAND LTD", "STATE STR RESEARCH & MGMT CO", ///
"STATE STR RESEARCH & MGMT CO.", "STATE STR RESR & MGMT", "STATE STREET BOSTON CORP")
replace repl = 1 if inlist(mgrname, "STATE STREET CORP", "STATE STREET RES. & MGMT", "STATE STREET RESR & MGMT")
replace mgrno_mapped = 81540 if repl == 1

replace repl = 0
replace repl = 1 if inlist(mgrname, "VANGUARD GROUP", "VANGUARD GROUP INC", "VANGUARD GROUP, INC.")
replace mgrno_mapped = 90457 if repl == 1
drop repl

save 2.intermediate\bushee_detailed, replace

